/*******************************************************************************
* Device      : AD18F08
* Author      : XAD SE Team
* Version     : V0.0.1
* Date        : 20220825
* Description : 系统外设驱动函数
********************************************************************************/

#ifndef __PERIPH_H__
#define __PERIPH_H__

#include "AD18F08.h"
#include "Periph.h"

#define BIT(x)  (1<<x)
#define POUT(x,y) TRIS##x &= ~BIT(y)
#define PIN(x,y) TRIS##x |= BIT(y)




void GPIO_INIT();

//Pch:0-PB6,1-PA3,2-PB4,3-PA0,4-DAC,5-ADC_MUX,6-FVR,7-GND
//Nch:0-PB7,1-PA5,2-PA2,3-PB2,4-DAC,5-ADC_MUX,6-FVR,7-PA1
//Mode<7>:  0-不输出到IO(PB6),1-输出到IO(PB6)
//Mode<6>:  0-不输出到IO(PB1),1-输出到IO(PB1)
//Mode<5>:  0-不输出到IO(PA5),1-输出到IO(PA5)
//Mode<4>:  0-不输出到IO(PA1),1-输出到IO(PA1)
//Mode<0>:  0-禁止,1-使能
void Cmp_Cfg(unsigned char Pch,unsigned char Nch,unsigned char Mode);


#endif